(
	-- Autodesk Map (only "Bitmap" supported currently)

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			case mtl.basetype of 
			(
				"Bitmap" : (
					"d21c6827-57cb-4bb5-86a6-ace0e02f6646" 
				)
				"Noise" : (
					"6435caa8-affa-4e68-b7d3-e768ca5cadeb"
				)
				default : (
					-- TODO: Fallback to "Bitmap"
					-- And it will attempt to bake it....
					undefined
				)
			)
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			try (
				case mtl.basetype of 
				(
					"Bitmap" : (
						append res #("uvw",      undefined, "uvw_"       + (mtl.Advanced_Parameters_Map_Channel as String))
						append res #("utangent", undefined, "u_tangent_" + (mtl.Advanced_Parameters_Map_Channel as String))
						append res #("vtangent", undefined, "v_tangent_" + (mtl.Advanced_Parameters_Map_Channel as String))
					)
					"Noise" : (
						local out = "result"
						if (context == 1) do out = "normalPerturb" -- bump mode
			
						if mtl.Appearance_Color_1_Map != undefined and mtl.Appearance_Color_1_Option==1 do 
						(
							append res #("Color1", mtl.Appearance_Color_1_Map, out)
							append res #("Alpha1", mtl.Appearance_Color_1_Map, "alpha")
							append res #("Float1", mtl.Appearance_Color_1_Map, "resultFloat")
						)
						if mtl.Appearance_Color_2_Map != undefined and mtl.Appearance_Color_2_Option==1 do 
						(
							append res #("Color2", mtl.Appearance_Color_2_Map, out)
							append res #("Alpha2", mtl.Appearance_Color_2_Map, "alpha")
							append res #("Float2", mtl.Appearance_Color_2_Map, "resultFloat")
						)
					)
				)
			)
			catch (
				-- Do nothing in particular, this is normal
				print "GetMaps Failed"
				print mtl
				print res
				showProperties mtl
			)

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	
			local mtx = matrix3 1

			-- Accessing mtl.bitmap causes an MXS exception if the file cannot be found!!
			try (
				case mtl.basetype of 
				(
					"Bitmap" : (
						append res #("Bitmap",     mtl, "Parameters_Source")

						append res #("out_amount", mtl.Parameters_Brightness / 100.0)
						append res #("invert",     mtl.Parameters_Invert_Image)
						append res #("blur",       mtl.Advanced_Parameters_Blur)
						append res #("blurOffs",   mtl.Advanced_Parameters_Blur_Offset)

						append res #("utile",      mtl.Repeat_Horizontal)
						append res #("vtile",      mtl.Repeat_Vertical)

						local  mtx_rot   = RotateZMatrix -mtl.Position_Rotation
						local  mtx_scale = ScaleMatrix (Point3 mtl.Scale_Width  mtl.Scale_Height  1.0)
						local  mtx_move  = TransMatrix (Point3 mtl.Position_X   mtl.Position_Y    1.0)

						mtx = inverse (mtx_rot * mtx_scale * mtx_move)

						append res #("UVTransform",        mtx)
						append res #("TangentTransform",   mtx_rot)
					)
					"Noise" : (
						append res #("Color1", mtl.Appearance_Color_1)
						append res #("Color2", mtl.Appearance_Color_2)
						append res #("Alpha1", 1.0)
						append res #("Alpha2", 1.0)
						append res #("Float1", (mtl.Appearance_Color_1.r+mtl.Appearance_Color_1.g+mtl.Appearance_Color_1.b)/768.0)
						append res #("Float2", (mtl.Appearance_Color_2.r+mtl.Appearance_Color_2.g+mtl.Appearance_Color_2.b)/768.0)
						append res #("Map1on", mtl.Appearance_Color_1_Map != undefined and mtl.Appearance_Color_1_Option==1)
						append res #("Map1on", mtl.Appearance_Color_2_Map != undefined and mtl.Appearance_Color_2_Option==1)

						append res #("type",      mtl.Appearance_Noise_Type)
						append res #("scale",     1.0/mtl.Appearance_Size)

						append res #("levels",    mtl.Noise_Threshold_Levels)
						append res #("lowThresh", mtl.Noise_Threshold_Low)
						append res #("hiThresh",  mtl.Noise_Threshold_High)
						append res #("phase",     mtl.Noise_Threshold_Phase)

						local UVTransform = transMatrix (point3 mtl.Position_X mtl.Position_Y mtl.Position_Z)

						UVTransform *= rotateXmatrix mtl.Position_XYZ_Rotation.x
						UVTransform *= rotateYmatrix mtl.Position_XYZ_Rotation.y
						UVTransform *= rotateZmatrix mtl.Position_XYZ_Rotation.z

						append res #("UVTransform", UVTransform)
						append res #("TangentTransform", orthogonalize(copy UVTransform))

					)
				)
			)
			catch (
				-- Do nothing in particular, this is normal
				print "GetParams Failed"
				print mtl
				print res
				showProperties mtl
			)

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAAOFisQ7hdZ6mKMapNGU4xjFTUcaCvPNbi
-- FRiF+E94RmuwlLZ7lzWvbLoMaQEa0hyKe2E0UtTtE0gZrWM1Yidq/WHLk1blkp4g
-- hj2qeQyxkWXjAy7sPuzWS3+GWBAGvUG89NqicbMG2X9+v6TcH+V+HrDy2ggpMZyL
-- Hl6wt7HqhaF8lfQ1oUIl9Q2i4MlVDWrZCdbf/w5zsJTiFDLbQiKpRKpHyxqzIv4m
-- jm80QZl0TSOMb0cA2M2/ZwGVpuJCezyPD/7U3zZBHGBsAzNto9Jz8J7QXFv4VsEF
-- siGHuv64lCZkzEiqknb9V04S1vDgYr7MInjFFKGNJyuyLRNUZnSW
-- -----END-SIGNATURE-----